<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;
    protected $fillable = array('pocket_id', 'payload', 'sender_id', 'receiver_id', 'pockets_name', 'isSharePocket', 'isArchived', 'isFriendRequest');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function pocket()
    {
        return $this->belongsTo('App\Models\Pocket', 'pocket_id');
    }

}